﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Common
{
    public partial class PatientCprs : BasePage
    {
        #region Protected Methods

        protected override void Page_Load(object sender, EventArgs e)
        {
            base.Page_Load(sender, e);

            bool isError = false;
            ViaServiceData viaData = new ViaServiceData();

            //Get parameters from querystring 
            viaData.SiteCode = Request.QueryString["q9gtw0"];
            viaData.DUZ = Request.QueryString["yiicf"];
            viaData.DFN = Request.QueryString["xqi4z"];
            viaData.ServerIP = Request.QueryString["jbPI0202"];
            viaData.ServerPort = Request.QueryString["27trp"];

            int temp = 0;
            if (int.TryParse(Request.QueryString["5Sfty21"], out temp))
                viaData.CprsSentTBIEvaluationNoteId = temp;

            temp = 0;
            if (int.TryParse(Request.QueryString["45vlw93"], out temp))
                viaData.CprsSentTBIFollowUpNoteId = temp;

            //Get parameters from querystring 
            //Session["SiteCode"] = Request.QueryString["q9gtw0"];
            //Session["DUZ"] = Request.QueryString["yiicf"];
            //Session["DFN"] = Request.QueryString["xqi4z"];
            //Session["ServerIP"] = Request.QueryString["jbPI0202"];
            //Session["ServerPort"] = Request.QueryString["27trp"];
            //Session["TBIEvaluationNoteId"] = Request.QueryString["5Sfty21"];
            //Session["TBIFollowUpNoteId"] = Request.QueryString["45vlw93"];

            //if (Helpers.IsSessionVariableNullOrEmpty(Session["DUZ"])
            //    || Helpers.IsSessionVariableNullOrEmpty(Session["DFN"])
            //    || Helpers.IsSessionVariableNullOrEmpty(Session["SiteCode"])
            //    || Helpers.IsSessionVariableNullOrEmpty(Session["ServerIP"])
            //    || Helpers.IsSessionVariableNullOrEmpty(Session["ServerPort"]))

            string sError = "PatientCprs.Page_Load(): WarningRedirect: null or missing query string values: ";
            if (string.IsNullOrEmpty(viaData.DUZ))
            {
                sError += "DUZ;";
                isError = true;
            }
            if (string.IsNullOrEmpty(viaData.DFN))
            {
                sError += "DFN;";
                isError = true;
            }
            if (string.IsNullOrEmpty(viaData.SiteCode))
            {
                sError += "SiteCode;";
                isError = true;
            }
            if (string.IsNullOrEmpty(viaData.ServerIP))
            {
                sError += "ServerIP";
                isError = true;
            }
            if (string.IsNullOrEmpty(viaData.ServerPort))
            {
                sError += "ServerPort";
                isError = true;
            }

            if (isError)
            { 
                ServiceInterfaceManager.LogError(sError, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

                //if any value is not passed in then the page was called incorrectly, display error message to user
                lblMessage.Text = "Incorrect value has been passed from CPRS.";
            }
            else
            {
                //var r = ServiceInterfaceManager.STD_REGISTRY_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, 3018);
                var registryCode = Request.QueryString["registryCode"];
                var registries = ServiceInterfaceManager.STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                var r = registries.Where(x => x.CODE == registryCode).SingleOrDefault();

                if (r != null)
                {
                    Response.Redirect(String.Format("PatientCprsMain.aspx?id={0}", r.ID));
                }
                else
                {
                    lblMessage.Text = "Registry code passed from CPRS does not exist.";
                }
                //Response.Redirect("PatientCprsMain.aspx");
            }
        }
        #endregion
    }
}